import logging
from io import BytesIO

from wiki.files.api import detect_image
from wiki.files.models import File
from wiki.utils.tasks.base import LockedCallableTask

logger = logging.getLogger('wiki.files')

# Отключено за ненадобностью
# @receiver(post_save, sender=File, weak=False, dispatch_uid='file created')
# def detect_file_params(sender, instance, **kwargs):
#     is_img = instance.url.split('.')[-1].lower() in ('jpg', 'jpeg', 'png', 'gif', 'bmp')
#
#     # при сохранении инстанс может еще не иметь mds_storage_id
#     if instance.mds_storage_id and is_img and not (instance.image_width and instance.image_height):
#         logger.debug('creating task to detect image file id=%s dimension', instance.pk)
#         on_commit(lambda: DetectImageDimensionsTask().apply_async(tuple(), dict(file_id=instance.pk)))


class DetectImageDimensionsTask(LockedCallableTask):
    """
    Определить размер файла-картинки.
    """

    name = 'wiki.detect_image_dimensions'
    logger = logging.getLogger(__name__)
    time_limit = 60  # 60 сек
    lock_name_tpl = 'detect_image_dimensions_{file_id}'

    def run(self, file_id, *args, **kwargs):
        try:
            file_obj = File.active.get(pk=file_id)
        except File.DoesNotExist:
            logger.warning('file id=%d does not exist', file_id)
        else:
            logger.debug('detecting image file id=%s dimensions', file_obj.pk)
            file_obj.image_width, file_obj.image_height = detect_image(BytesIO(file_obj.mds_storage_id.read()))
            file_obj.save()
