from celery.utils.log import get_task_logger

from wiki.utils.tasks.base import LockedCallableTask


class UpdateCommentsStatusTask(LockedCallableTask):
    """
    Обновить статус комментариев у некоторых страниц по переданному списку ID.
    """

    name = 'wiki.update_comments_status'
    logger = get_task_logger(__name__)
    time_limit = 60 * 10  # 600 сек
    lock_name_tpl = 'update_comments_status_{root_page_id}'

    def run(self, root_page_id, comments_status, child_pages_ids, *args, **kwargs):
        from wiki.pages.logic.comment import update_comments_status

        update_comments_status(child_pages_ids, comments_status)
