"""
Таск access_status.

@author: chapson
"""
from functools import partial

from celery.task import task

from wiki.pages.access.external import bulk_update_ext_access_status
from wiki.utils import lock


@task(ingore_result=True, name='wiki.update_page_access_status')
def access_status():
    """
    Обновить в mysql флаг opened_to_external_flag

    У всех активных страниц проверяет и обновляет флаг доступности внешним пользователям
    opened_to_external_flag
    """
    try:
        # всем открытых внешним пользователям выставляется флаг opened_to_external_flag True
        lock.execute_with_lock('update_ext_status', partial(bulk_update_ext_access_status))

    except lock.FailedToGetLockError:
        pass
