from celery.utils.log import get_task_logger

from wiki.utils.tasks.base import LockedCallableTask


class UpdateReadonlyModeTask(LockedCallableTask):
    """
    Обновить значение режима read-only у некоторых страниц по переданному списку ID.
    """

    name = 'wiki.update_readonly_mode'
    logger = get_task_logger(__name__)
    time_limit = 60 * 10  # 600 сек
    lock_name_tpl = 'update_readonly_mode_{root_page_id}'

    def run(self, root_page_id, is_readonly, child_pages_ids, user_id, *args, **kwargs):
        from wiki.pages.logic.readonly_mode import update_readonly_mode

        update_readonly_mode(child_pages_ids, user_id, is_readonly)
