from celery.utils.log import get_task_logger

from wiki.pages.management.commands.tmp_remove_unused_objects import remove_revisions_of_deleted_pages
from wiki.utils.tasks.base import LockedCallableTask


class RemoveRevisionsOfDeletedPagesTask(LockedCallableTask):
    """
    Удалить лишние (избыточные) ревизии у удаленных страниц для освобождения места в хранилище.
    """

    name = 'wiki.remove_revisions_of_deleted_pages'
    logger = get_task_logger(__name__)
    time_limit = 60 * 60  # 3600 сек
    lock_name_tpl = 'remove_revisions_of_deleted_pages'
    recent_revisions_count = 50
    revisions_count_for_select = 100

    def run(self, *args, **kwargs):
        remove_revisions_of_deleted_pages(
            recent_revisions_count=self.recent_revisions_count,
            revisions_count_for_select=self.revisions_count_for_select,
        )
