"""
    Функции из этого модуля используются в новом форматтере для определения
    свойств влияющих на поведение экшена {{include}} с параметрами if_*
"""
from typing import Tuple

from wiki.pages.access import user_group_ids
from wiki.users.models import Group
from wiki.intranet.models import Staff


def get_office(staff):
    if staff.office:
        return staff.office.code


def get_city(staff):
    if staff.office and staff.office.city:
        return str(staff.office.city.id)


def get_country(staff):
    if staff.office and staff.office.city and staff.office.city.country:
        return str(staff.office.city.country.id)


def get_group(staff: Staff) -> Tuple[str]:
    user_gr_ids = user_group_ids(staff)
    return tuple(Group.objects.filter(id__in=user_gr_ids).values_list('url', flat=True))


def get_lang(staff):
    return staff.lang_ui
