
from urllib.parse import quote


def set_time_parameter(objects_with_created_at, attribute_of_time='created_at'):
    """
    Установить переданному списку ревизий атрибут time_parameter.

    @type objects_with_created_at: list
    @type attribute_of_time: str
    """
    for object in objects_with_created_at:
        object.time_parameter = quote(format_time_parameter(getattr(object, attribute_of_time)))
    return objects_with_created_at


def format_time_parameter(datetime):
    """
    Сделать строку в UTC формата Y-m-d+H:i:s из даты создания ревизии

    для корректной ссылки

    @type datetime: datetime
    """
    return datetime.strftime('%Y-%m-%d %H:%M:%S')
