
from django.contrib.auth import get_user_model
from django.core.management import BaseCommand
from wiki.intranet.models import Staff

from wiki.personalisation.logic import nodejs_frontend_enabled
from wiki.personalisation.user_cluster import NoPersonalCluster, get_notes_cluster, personal_cluster
from wiki.users.logic import get_user_setting, set_user_setting


def personal_page_and_notes(user):
    """
    Вернуть личный кластер и заметки.

    @rtype: list
    """
    result = []
    try:
        result.append(personal_cluster(user))
    except (Staff.DoesNotExist, NoPersonalCluster):
        return result

    result.append(get_notes_cluster(result[0]))
    return result


class Command(BaseCommand):
    help = '''Users should use nodejs'''
    requires_system_checks = False

    def handle(self, *args, **options):
        if not nodejs_frontend_enabled():
            print('nodejs is not available for this instance.')
            return
        for user in get_user_model().objects.all():
            if get_user_setting(user, 'use_nodejs_frontend'):
                continue
            print(user, 'is using NodeJS front')
            set_user_setting(user, 'use_nodejs_frontend', True)
