"""
Модуль находится тут, а не в wiki.users, потому что нельзя
использовать этот сигнал в users из-за get_user_model. Импорт устроен
так, что регистрация сигнала фейлится потому что нельзя определить
пользователя на момент вызова get_user_model, если этот сигнал
лежит в users.
"""
from django.contrib.auth import get_user_model
from django.db.models.signals import pre_save
from django.dispatch import receiver

from wiki.personalisation.logic import nodejs_frontend_enabled


@receiver(pre_save, sender=get_user_model(), weak=False)
def init_user_profile(sender, **kwargs):
    wiki_user = kwargs['instance']

    if not wiki_user.pk:  # сейчас запись будет создана
        # добавить в профайл нового пользователя дефолтные настройки
        wiki_user.profile = {
            'theme_lang': 'en',
            'code_theme': 'github',
            'minimize_bookmarks': False,
            'use_nodejs_frontend': nodejs_frontend_enabled(),
            'double_click': True,
            'new_favorites': True,
            'new_subscriptions': True,
        }
