"""
Различные вспомогательные функции.

@author: chapson
"""
import logging

from django.contrib.admin import AdminSite
from django.contrib.auth import get_user_model
from django.http import HttpRequest

from wiki.users.admin_forms import UserAdminExternal

logger = logging.getLogger(__name__)


class UserCreationFailed(Exception):
    pass


def create_user(username, email, first_name, last_name, uid=None):
    """
    Создает пользователя с помощью формы. Функция для использования в консоли вручную.

    string, string, string, string, string|None -> User|None
    """

    user_admin = UserAdminExternal(get_user_model(), AdminSite())
    AddUserForm = user_admin.get_form(HttpRequest())

    form = AddUserForm(
        {
            'username': username,
            'email': email,
            'first_name': first_name,
            'last_name': last_name,
            'uid': uid,
        }
    )
    if form.is_valid():
        user = form.save()
        return user

    raise UserCreationFailed('User creation was unsuccessful. Details: %s' % form.errors.as_text())
