
"""
ping_mongo management command.
Prints '0;OK' if all ok.
Prints '2;{error description}' in case of error.
"""

from random import randint

from django.conf import settings
from django.core.management.base import BaseCommand
from pymongo import uri_parser
from tools_mongodb_cache.cache import MongoDBWrapper


class Command(BaseCommand):
    help = 'Trying to determine if mongo works correctly.' 'Return status in monrun-compliant format'
    requires_system_checks = False

    def handle(self, *args, **options):
        try:
            database = uri_parser.parse_uri(settings.MONGO_CONNECTION_URL)['database']
            mongo = MongoDBWrapper(
                database_name=database,
                hosts=settings.MONGO_CONNECTION_URL,
                replica_set=settings.MONGO_REPLICA_SET_NAME
            )
            collection = getattr(mongo.connection, settings.MONGO_DATABASE).ping

            unique_value = randint(0, 10 ** 7)

            collection.insert({'ping': unique_value}, w=(settings.MONGO_CONNECTION_URL.count(',') + 1))
            assert collection.find_one({'ping': unique_value}), 'Failed to write an object'

            collection.remove({'ping': unique_value}, w=(settings.MONGO_CONNECTION_URL.count(',') + 1))
            assert collection.find_one({'ping': unique_value}) is None, 'Failed to remove an object'

        except Exception as exc:
            print('2;{0}'.format(exc))

        else:
            print('0;OK')
