import logging

from celery.task import task

from wiki.celery_apps import app
from wiki.ping.models import TouchMe
from wiki.utils import lock
from wiki.utils.tasks.base import LockedCallableTask

logger = logging.getLogger(__name__)


@task(ignore_result=True, name='wiki.ping')
@lock.get_lock_or_do_nothing('ping_lock')
def touch():
    """
    Пытается обновить timestamp у 1го объекта TouchMe в базе
    """
    try:
        item = TouchMe.objects.get()
    except TouchMe.DoesNotExist:
        item = TouchMe()

    item.save()


class DebugTask(LockedCallableTask):
    name = 'wiki.debug_locks'

    def run(self, *args, **kwargs):
        print('!!!')


app.tasks.register(DebugTask)
