import logging

from django.conf import settings
from django.http import HttpResponse
from django_replicated.dbchecker import db_is_alive
from django_replicated.utils import routers
from wiki.ping.models import TouchMe

logger = logging.getLogger('ping')


def databases_for_reading_left():
    """
    Вернуть False, если не осталось базы из которой можно читать.

    Для сервиса наличие базы на чтение критично.

    @rtype: bool
    """
    # любая модель подходит, в том числе TouchMe!
    db_instance_name = routers.db_for_read(TouchMe)
    if db_instance_name == routers.DEFAULT_DB_ALIAS:
        # django_replicated не проверяет мастер на живость в db_for_read
        if not db_is_alive(db_instance_name, number_of_tries=3):
            # мы попытаемся сходить в мертвый мастер. Баз на чтение не осталось
            return False
    return True


def simple_ping(request):
    """
    Ручка простого пинга джанги.
    """
    message = 'I\'m alive. {0}\n'.format(settings.API_WIKI_HOST)

    return HttpResponse(message, content_type='text/plain')


def ping_database(request):
    """
    Ручка пингa базы данных и джанги.
    """
    message = 'I\'m alive. {0}\n'.format(settings.API_WIKI_HOST)
    status = 200

    if not databases_for_reading_left():
        status = 500
        message = 'Can\'t connect to database'
        logger.exception(message)

    return HttpResponse(message, status=status, content_type='text/plain')


def ping_celery(request):
    return HttpResponse('I\'m alive (but disabled lol)', content_type='text/plain')


def ping_sync_staff(request):
    return HttpResponse('I\'m alive (but disabled lol)', content_type='text/plain')


def ping_updatecenter(request):
    return HttpResponse('I\'m alive (but disabled lol)', content_type='text/plain')
