# flake8: noqa
# isort:skip_file
import os

import granular_settings
import yenv

from wiki.arc_compat import is_arc, env_bool, env_str

WIKI_CODE = env_str('wiki_code')

WIKI_INSTANCE_TYPE = {
    'wiki': 'internal',
    'evaluation': 'internal',
    'school': 'external',
    'biz': 'external',
}[WIKI_CODE]

IS_BUSINESS = WIKI_CODE == 'biz'

_environments = '%s,%s' % (WIKI_CODE, WIKI_INSTANCE_TYPE)
_location = os.path.abspath(os.path.dirname(__file__))

if 'IS_LOCAL' in os.environ or 'IS_TESTS' in os.environ:
    # Девелоперский инстанс или запуск тестов в Docker
    _environments += ',local'

os.environ.setdefault('granular_environments', _environments)

envtype = None
if is_arc() and env_bool('IS_TESTS'):
    envtype = 'arctest'

granular_settings.set(
    globals(),
    envtype=envtype,
    path='intranet/wiki/src/wiki/settings' if is_arc() else os.path.join(_location, 'settings'),
)
