from typing import List

from enumfields import EnumField
from django.conf import settings
from django.db import models
from django.contrib.postgres.fields import JSONField

from wiki.pages.models import Page
from wiki.subscriptions.consts import SubscriptionType
from wiki.utils.timezone import now


class Subscription(models.Model):
    """
    Модель подписки пользователя на кластер или отдельную страницу
    """

    id: models.IntegerField
    objects: models.Manager

    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE)

    page = models.ForeignKey(Page, on_delete=models.CASCADE)

    type = EnumField(SubscriptionType)

    exclude = JSONField(default=dict)

    is_cluster = models.BooleanField(default=False)

    created_at = models.DateTimeField(default=now)

    class Meta:
        constraints = [models.UniqueConstraint(fields=['user', 'page'], name='unique_subscription')]

    @property
    def excludes(self) -> List[str]:
        return self.exclude.get('exclude', [])

    def __str__(self):
        return f'id={self.id}, user={self.user}, page={self.page}, is_cluster={self.is_cluster}, type={self.type}'
