from django.db import models
from django.conf import settings
from enumfields import EnumField
from wiki.support_tools.consts import SupportOperation
from django.contrib.auth import get_user_model

User = get_user_model()


class SupportLog(models.Model):
    created_at = models.DateTimeField(auto_now_add=True)
    user = models.ForeignKey(settings.AUTH_USER_MODEL, related_name='supportlog', on_delete=models.CASCADE)
    operation = EnumField(SupportOperation, max_length=16)
    request = models.TextField(null=True)
    details = models.TextField(null=True)

    def __str__(self):
        return f'<SupportLog {self.user}: {self.operation} at {self.created_at}>'


def log_operation(user: User, operation: SupportOperation, request: str, details: str):
    SupportLog.objects.create(user=user, operation=operation, request=request, details=details)
