import logging

from grpc._channel import _InactiveRpcError
from rest_framework.response import Response

from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises
from wiki.sync.cloud.client import OrganizationCreationError, OrganizationEnsureError
from wiki.sync.cloud.create_organization_serializer import (
    CreateCloudOrganizationResponceSerializer,
    CreateCloudOrganizationSerializer,
)
from wiki.sync.cloud.schemas.errors import CreateOrganizationError, GRPCError
from wiki.sync.connect.tasks.helpers import create_new_org_in_cloud, ensure_cloud_org_in_connect

logger = logging.getLogger(__name__)


class CreateCloudOrganizationView(WikiAPIView):
    serializer_class = CreateCloudOrganizationSerializer

    @raises()
    def post(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)

        try:
            cloud_org_id = create_new_org_in_cloud(request.data['org_name'], request.data['user_iam_token'])
            dir_id = ensure_cloud_org_in_connect(cloud_org_id, request.data['user_iam_token'])
        except (OrganizationCreationError, OrganizationEnsureError):
            raise CreateOrganizationError()
        except _InactiveRpcError as e:
            raise GRPCError(details=e.details())

        return Response(CreateCloudOrganizationResponceSerializer({'org_id': dir_id}).data)
