from django.db.models.query import QuerySet
from django.conf import settings


class BaseOrganization:
    def get_users(self) -> QuerySet:
        raise NotImplementedError()

    def get_pages(self) -> QuerySet:
        raise NotImplementedError()

    def get_lang(self) -> str:
        raise NotImplementedError()

    def get_location_history(self) -> QuerySet:
        raise NotImplementedError()

    def get_active_pages(self) -> QuerySet:
        raise NotImplementedError()

    def get_groups(self) -> QuerySet:
        raise NotImplementedError()

    def as_django_model(self):
        raise NotImplementedError()

    def external_id(self) -> str | None:
        raise NotImplementedError()

    def unique_id(self) -> str:
        raise NotImplementedError()

    def as_django_model_pk(self) -> int:
        raise NotImplementedError()

    def inner_id(self) -> int | None:
        """
        ID в базе данных Вики, наружу не пролазит.
        :return:
        """
        raise NotImplementedError()


def as_base_organization(org) -> BaseOrganization:
    if settings.IS_INTRANET or (settings.IS_TESTS and org is None):
        # IntranetOrganization нужно возвращать только для интранет окружения
        # но это ломает часть тестов, которые в б2б выполняются без контекста организации
        from wiki.sync.connect.intranet_org import IntranetOrganization

        return IntranetOrganization()
    else:
        return org
