from wiki.sync.connect.base_organization import BaseOrganization
from django.conf import settings


def get_organization_by_inner_id(idx: int) -> BaseOrganization:
    if settings.IS_INTRANET:
        # IntranetOrganization нужно возвращать только для интранет окружения
        from wiki.sync.connect.intranet_org import IntranetOrganization

        return IntranetOrganization()
    else:
        from .models import Organization

        return Organization.objects.get(pk=idx)
