from django.contrib.auth import get_user_model
from django.db.models.query import QuerySet
from wiki.users.models import Group
from wiki.pages.models import Page, LocationHistory
from wiki.sync.connect.base_organization import BaseOrganization


class IntranetOrganization(BaseOrganization):
    def get_users(self) -> QuerySet:
        return get_user_model().objects

    def get_location_history(self) -> QuerySet:
        return LocationHistory.objects

    def get_pages(self) -> QuerySet:
        return Page.objects

    def get_lang(self) -> str:
        return 'ru'

    def get_active_pages(self) -> QuerySet:
        return Page.active

    def as_django_model(self):
        return None

    def as_django_model_pk(self):
        return None

    def external_id(self) -> None:
        return None

    def unique_id(self) -> str:
        return '0'

    def get_groups(self) -> QuerySet:
        return Group.objects

    def inner_id(self) -> None:
        return None
