# Generated by Django 1.9.9 on 2017-08-16 10:39


import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
from jsonfield import JSONField
import django.utils.timezone
import model_utils.fields

from wiki.sync.connect.models import get_default_operating_mode_limits, get_default_org_statistics


class Migration(migrations.Migration):

    dependencies = [
        ('connect', '0006_remove_org_label_index'),
    ]

    operations = [
        migrations.CreateModel(
            name='OperatingMode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name='modified'
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        help_text='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 '
                        '\u0440\u0435\u0436\u0438\u043c\u0430',
                        max_length=50,
                        unique=True,
                    ),
                ),
                (
                    'limits',
                    JSONField(
                        default=get_default_operating_mode_limits,
                        help_text='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 "-1" '
                        '\u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442 "\u0431\u0435\u0437 '
                        '\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439"',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'db_table': 'dir_data_sync_operatingmode',
            },
        ),
        migrations.CreateModel(
            name='OrgStatistics',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name='modified'
                    ),
                ),
                (
                    'is_limits_exceeded',
                    models.BooleanField(
                        default=False,
                        help_text='\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u044b '
                        '\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f '
                        '\u0440\u0435\u0436\u0438\u043c\u0430 \u0440\u0430\u0431\u043e\u0442\u044b '
                        '\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438',
                    ),
                ),
                (
                    'statistics',
                    JSONField(
                        default=get_default_org_statistics,
                        help_text='\u043d\u0430\u0431\u043e\u0440 \u043e\u0431\u0449\u0438\u0445 \u0434\u043b\u044f '
                        '\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 '
                        '\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445'
                        ' \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439',
                    ),
                ),
                (
                    'org',
                    models.OneToOneField(
                        help_text='\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f',
                        to='connect.Organization',
                        on_delete=models.CASCADE,
                    ),
                ),
            ],
            options={
                'abstract': False,
                'db_table': 'dir_data_sync_orgstatistics',
            },
        ),
    ]
