# Generated by Django 1.9.9 on 2017-08-07 18:11

from django.conf import settings
from django.db import migrations

from wiki.sync.connect import OPERATING_MODE_NAMES


def init_operating_mode(apps, schema_editor):

    OperatingModeModel = apps.get_model('connect', 'OperatingMode')
    OperatingModeModel.objects.create(
        name=OPERATING_MODE_NAMES.free,
        limits=settings.DIRSYNC_OPERATING_MODE_LIMITS_BY_MODE_NAME[OPERATING_MODE_NAMES.free],
    )
    OperatingModeModel.objects.create(
        name=OPERATING_MODE_NAMES.paid,
        limits=settings.DIRSYNC_OPERATING_MODE_LIMITS_BY_MODE_NAME[OPERATING_MODE_NAMES.paid],
    )


def remove_operating_mode(apps, schema_editor):
    OperatingModeModel = apps.get_model('connect', 'OperatingMode')
    OperatingModeModel.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('connect', '0007_add_operatingmode_and_orgstatistics'),
    ]

    operations = [
        migrations.RunPython(init_operating_mode, remove_operating_mode),
    ]
