from django.conf import settings
from pydantic import BaseModel
from wiki.api_v2.exceptions import BadRequest
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.sync.connect.intranet_org import IntranetOrganization
from wiki.sync.connect.models import Organization


class OrganizationIdentity(BaseModel):
    dir_id: str = None
    cloud_id: str = None

    def to_organization(self) -> BaseOrganization:
        if not settings.IS_BUSINESS:
            return IntranetOrganization()

        try:
            return Organization.objects.get(dir_id=self.dir_id)
        except Organization.DoesNotExist:
            raise BadRequest('Organization does not exist')

    @classmethod
    def from_organization(cls, o: BaseOrganization):
        if isinstance(o, IntranetOrganization):
            return OrganizationIdentity()

        if isinstance(o, Organization):
            return OrganizationIdentity(dir_id=o.dir_id)

        raise ValueError(f'What are you even? ({o})')
