from enum import Enum
from pydantic import BaseModel

CACHE_FORCED_SYNC_TIMEOUT = 10 * 60  # in sec
CLOUD_SYNC_CONNECT_TIMEOUT = 60  # in sec
NEW_ORG_CONNECT_NAME = 'Новая организация'


class ForcedSyncStatus(str, Enum):
    OK = 'ok'
    FAILED = 'failed'
    IN_PROGRESS = 'in_progress'


class ForcedSyncErrorCode(str, Enum):
    DIR_HAS_NO_CLOUD_USER = 'error_1.4'
    FAILED_TO_CREATE_NEW_ORG = 'error_2.3a'
    DIR_HAS_NO_NEW_ORG = 'error_2.3b'
    DIR_HAS_NO_ORG = 'error_2.3c'
    ORPHAN_FED_USER = 'error_5'
    USER_DOESNT_BELONG_TO_ORG = 'user_org_mismatch_or_deactivated'
    FAILED_TO_ENABLE_SVC = 'error_4.1'
    BAD_LUCK = 'error_5'
    SERDES_ERROR = 'error_0.0'
    UNHANDLED_EXCEPTION = 'error_0.1'
    DIR_THIS_IS_PORTAl = 'error_org_is_portal'
    NOT_FOUND_CLOUD_ORG_ID = 'not_found_cloud_org_id'


class ForcedSyncResult(BaseModel):
    result: ForcedSyncStatus
    error_code: ForcedSyncErrorCode | None = None
    org_id: str | None = None  # dir_id


class ForcedSyncError(Exception):
    def __init__(self, code: ForcedSyncErrorCode):
        self.code = code
