
from functools import partial

from django.core.management.base import BaseCommand
from wiki.sync.staff.mptt_healthcheck import healthcheck as hc
from wiki.sync.staff.tasks.sync_staff import SyncStaffModelsTask
from wiki.utils import lock


class Command(BaseCommand):
    help = 'check mptt tree'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('--fix-corrupted', action='store_true', default=False, dest='fix_corrupted')

    def handle(self, *args, **options):
        fix_corrupted = options.get('fix_corrupted', False)
        lockname = SyncStaffModelsTask.name
        lock.execute_with_lock(lockname, partial(check_tree, fix_corrupted))


def check_tree(fix_corrupted):
    forest = hc.plant_forest()
    corrupted = forest.get_corrupted_trees()
    if corrupted:
        print(('There are corrupted trees: [{}]'.format(', '.join([str(tree_id) for tree_id in corrupted]))))
        if fix_corrupted:
            print('Fix it')
            for tree_id in corrupted:
                forest.rebuild_tree(tree_id, with_reload=False)
            forest.reload_trees()
            forest.apply_changes()
            print('Done')
    else:
        print('mptt tree is valid')
