
from wiki.sync.staff.mapping.exceptions import MappingPathNotFound
from wiki.utils.dict_keypath import resolve_path

NOT_SET = object()


class FieldMapping(object):
    """
    Отображение поля из источника данных в поле локальной модели

    Remote XPath:
    "attr.attr2.attr3[0]" => dict_val['attr']['attr2']['attr3'][0]
    """

    def __init__(
        self,
        field_name,
        remote_xpath,
        transformation=None,
        primary_mapping=False,
        required=False,
        default=NOT_SET,
        enum=None,
    ):
        """

        @param field_name:
        @param remote_xpath:
        @param transformation:
        @param primary_mapping:
        @param required: если путь не найден, будем падать
        @param default: если путь не найден, поставим default (если он не определен, игнорируем)
        @param enum:
        """
        self.default = default
        self.required = required
        self.primary_mapping = primary_mapping
        self.remote_field = remote_xpath.split('[')[0]
        self.remote_xpath = remote_xpath.split('.')
        self.field_name = field_name
        self.transformation = transformation
        self.enum = enum

    def get_remote_field(self):
        return self.remote_field

    def contribute_to_fields_dict(self, fields, remote_dict):
        try:
            val = self.get_value(remote_dict)
        except MappingPathNotFound:
            if self.required:
                raise
            return

        if self.transformation:
            val = self.transformation(val)

        fields[self.field_name] = val

    def get_value(self, remote_dict):
        try:
            val = resolve_path(self.remote_xpath, remote_dict)
        except (KeyError, IndexError):
            if self.default == NOT_SET:
                raise MappingPathNotFound
            val = self.default

        if self.enum and val:
            try:
                val = self.enum[val]
            except KeyError:
                raise ValueError('Unexpected enum value: %s' % val)

        return val
