from django.conf import settings

from wiki.sync.staff.mapping.models.city import CityMapper
from wiki.sync.staff.mapping.models.county import CountryMapper
from wiki.sync.staff.mapping.models.department import DepartmentMapper
from wiki.sync.staff.mapping.models.group import GroupMapper
from wiki.sync.staff.mapping.models.group_membership import GroupMembershipMapper
from wiki.sync.staff.mapping.models.office import OfficeMapper
from wiki.sync.staff.mapping.models.person import StaffMapper
from wiki.sync.staff.mapping.models.service import ServiceMapper
from wiki.sync.staff.mapping.registry import MapperRegistry

mapper_registry = MapperRegistry()

if settings.IS_INTRANET:
    mapper_registry.register(DepartmentMapper)
    mapper_registry.register(GroupMapper)
    mapper_registry.register(StaffMapper)
    mapper_registry.register(GroupMembershipMapper)
    mapper_registry.register(ServiceMapper)
    mapper_registry.register(CityMapper)
    mapper_registry.register(OfficeMapper)
    mapper_registry.register(CountryMapper)
