from wiki.intranet.models.intranet_extensions import City, Country
from wiki.sync.staff.mapping.field_mapping import FieldMapping
from wiki.sync.staff.mapping.repository_mapper import RepositoryMapper
from wiki.sync.staff.utils import inject_dt, is_deleted_to_intranet_status


class CityMapper(RepositoryMapper):
    repository_name = 'office'
    local_model = City

    field_filters_on_create = [inject_dt]
    pk_mappings = [FieldMapping('id', 'city.id')]

    deps = {'country_id': Country}

    field_mapping = [
        FieldMapping('intranet_status', 'city.is_deleted', is_deleted_to_intranet_status),
        FieldMapping('name', 'city.name.ru'),
        FieldMapping('name_en', 'city.name.en'),
        FieldMapping('country_id', 'city.country.id'),
    ]
