from wiki.intranet.models.intranet_extensions import Country
from wiki.sync.staff.mapping.field_mapping import FieldMapping
from wiki.sync.staff.mapping.repository_mapper import RepositoryMapper
from wiki.sync.staff.utils import inject_dt, is_deleted_to_intranet_status


class CountryMapper(RepositoryMapper):
    repository_name = 'office'
    local_model = Country

    field_filters_on_create = [inject_dt]
    pk_mappings = [FieldMapping('id', 'city.country.id')]
    field_mapping = [
        FieldMapping('intranet_status', 'city.country.is_deleted', is_deleted_to_intranet_status),
        FieldMapping('name', 'city.country.name.ru'),
        FieldMapping('name_en', 'city.country.name.en'),
        FieldMapping('yandex_domain', 'city.country.domain'),
        FieldMapping('geo_base_id', 'city.country.geobase.id'),
        FieldMapping('code', 'city.country.geobase.code'),
    ]
