
from wiki.intranet.models.intranet_extensions import Department
from wiki.sync.staff.mapping.field_mapping import FieldMapping
from wiki.sync.staff.mapping.repository_mapper import RepositoryMapper
from wiki.sync.staff.utils import inject_dt, is_deleted_to_intranet_status


def join_array_with_colon(arr):
    return ', '.join(arr)


class DepartmentMapper(RepositoryMapper):
    """
    Что не синкаем:

    kind_id -> скорее всего не используется, в новом апи отдается null
    from_staff_id
    en_name - есть name_en
    code -  ???
    bg_color
    fg_color
    clubs
    dynamic_url
    intranet_status
    position - Откуда брать?
    native_lang - Откуда брать?

    Дерево (MPTT)

    tree_id
    lft - экономия!
    rght
    level
    """

    repository_name = 'group'
    extra_lookups = {'type': 'department'}

    default_on_create = {'from_staff_id': 0}

    local_model = Department
    pk_mappings = [FieldMapping('id', 'department.id')]

    deps = {'parent_id': Department}

    field_filters_on_create = [inject_dt]

    field_mapping = [
        FieldMapping('intranet_status', 'department.is_deleted', is_deleted_to_intranet_status),
        FieldMapping('parent_id', 'parent.department.id', default=None),
        FieldMapping('name', 'department.name.full.ru'),
        FieldMapping('name_en', 'department.name.full.en'),
        FieldMapping('short_name', 'department.name.short.ru'),
        FieldMapping('short_name_en', 'department.name.short.en'),
        FieldMapping('description', 'department.description.ru'),
        FieldMapping('description_en', 'department.description.en'),
        FieldMapping('wiki_page', 'department.contacts.wiki'),
        FieldMapping('maillists', 'department.contacts.maillists', join_array_with_colon),
        FieldMapping('url', 'department.url'),
    ]
