
from wiki.intranet.models.intranet_extensions import Department, Group, Service
from wiki.sync.staff.mapping.field_mapping import FieldMapping
from wiki.sync.staff.mapping.repository_mapper import RepositoryMapper
from wiki.sync.staff.utils import inject_dt, is_deleted_to_intranet_status


class GroupMapper(RepositoryMapper):
    """
    что не синкаем -

    code
    native_lang
    position
    role_scope_id


    MPTT:
    lft  | rght | tree_id | level
    """

    repository_name = 'group'
    extra_lookups = {}
    local_model = Group
    field_filters_on_create = [inject_dt]
    mptt_parent_field = True

    deps = {'parent_id': Group, 'department_id': Department, 'service_id': Service}

    field_mapping = [
        FieldMapping('parent_id', 'parent.id', default=None),
        FieldMapping('intranet_status', 'is_deleted', is_deleted_to_intranet_status),
        FieldMapping('department_id', 'department.id', default=None),
        FieldMapping('service_id', 'service.id', default=None),
        FieldMapping('description', 'description', default=None),
        FieldMapping('name', 'name'),
        FieldMapping('url', 'url'),
        FieldMapping('externals_count', 'affiliation_counters.external'),
        FieldMapping('yandex_count', 'affiliation_counters.yandex'),
        FieldMapping('yamoney_count', 'affiliation_counters.yamoney'),
        FieldMapping('type', 'type', enum={'department': 1, 'service': 2, 'servicerole': 3, 'wiki': 0}),
    ]


class WikiGroupMapper(GroupMapper):
    extra_lookups = {'type': 'wiki'}


class ServiceGroupMapper(GroupMapper):
    extra_lookups = {'type': 'service,servicerole'}
