from wiki.intranet.models.intranet_extensions import City, Office
from wiki.sync.staff.mapping.field_mapping import FieldMapping
from wiki.sync.staff.mapping.repository_mapper import RepositoryMapper
from wiki.sync.staff.utils import inject_dt, is_deleted_to_intranet_status


class OfficeMapper(RepositoryMapper):
    repository_name = 'office'
    local_model = Office
    field_filters_on_create = [inject_dt]
    default_on_create = {'from_staff_id': 0}

    deps = {'city_id': City}

    field_mapping = [
        FieldMapping('intranet_status', 'is_deleted', is_deleted_to_intranet_status),
        FieldMapping('name', 'name.ru'),
        FieldMapping('name_en', 'name.en'),
        FieldMapping('city_id', 'city.id'),
        FieldMapping('address1', 'address.ru'),
        FieldMapping('address1_en', 'address.en'),
        FieldMapping('have_map', 'have_map'),
        FieldMapping('tz', 'timezone'),
        FieldMapping('code', 'code'),
        FieldMapping('fax', 'contacts.fax'),
        FieldMapping('phone', 'contacts.phone'),
    ]
