from django.contrib.auth import get_user_model

from wiki.intranet.models import Staff
from wiki.intranet.models.intranet_extensions import Department
from wiki.sync.staff.mapping.field_mapping import FieldMapping
from wiki.sync.staff.mapping.repository_mapper import RepositoryMapper
from wiki.sync.staff.utils import date_from_str, datetime_from_str, inject_dt, is_deleted_to_intranet_status


class StaffMapper(RepositoryMapper):
    """
    Мусорные колонки (не синкаем)

    middle_name - в стафф апи нет отдачи отчества (https://st.yandex-team.ru/STAFF-9511)
    from_staff_id - стираем, не используеся
    en_name - стираем, не используеся
    login_ld - логин на стаффе мог отличаться от AD - скорее всего не нужно
    last_offer_id - дропаем
    login_mail - не нужен

    is_big_boss - не испольуется

    domain

    desk_id
    edu_status | edu_place | edu_date
    vacation
    has_exchange

    hide_birthday_year
    hide_middle_name
    login_mail
    service_profile

    Мусорные колонки на рефакторинг (не синкаем):

    wiki_name
    normal_login - пишется при сохранении
    """

    repository_name = 'person'
    local_model = Staff
    field_filters_on_create = [inject_dt]

    deps = {'department_id': Department}

    field_mapping = [
        FieldMapping('uid', 'uid'),
        FieldMapping('login', 'login'),
        FieldMapping('intranet_status', 'is_deleted', is_deleted_to_intranet_status),
        FieldMapping('first_name', 'name.first.ru'),
        FieldMapping('last_name', 'name.last.ru'),
        FieldMapping('first_name_en', 'name.first.en'),
        FieldMapping('last_name_en', 'name.last.en'),
        FieldMapping('lang_ui', 'language.ui'),
        FieldMapping('lang_content', 'language.content'),
        FieldMapping('native_lang', 'language.native'),
        FieldMapping('department_id', 'department_group.department.id'),
        FieldMapping('is_dismissed', 'official.is_dismissed'),
        FieldMapping('is_homeworker', 'official.is_homeworker'),
        FieldMapping('is_robot', 'official.is_robot'),
        FieldMapping('affiliation', 'official.affiliation'),  # "enum": ["yandex", "yamoney", "external"] - identity
        FieldMapping('join_at', 'official.join_at', date_from_str),
        FieldMapping('quit_at', 'official.quit_at', date_from_str),
        FieldMapping('position', 'official.position.ru'),
        FieldMapping('position_en', 'official.position.en'),
        FieldMapping('address', 'personal.address.ru'),
        FieldMapping('address_en', 'personal.address.en'),
        FieldMapping('employment', 'official.employment', enum={'full': 'F', 'partial': 'P', 'secondary': 'D'}),
        FieldMapping('birthday', 'personal.birthday', date_from_str),
        FieldMapping('gender', 'personal.gender', enum={'male': 'M', 'female': 'F'}),
        FieldMapping('family_status', 'personal.family_status', enum={'single': 'S', 'married': 'M'}),
        FieldMapping('work_phone', 'work_phone'),
        FieldMapping('mobile_phone', 'personal.mobile_phone_number'),
        FieldMapping('car', 'cars[0].model'),
        FieldMapping('car_num', 'cars[0].plate'),
        FieldMapping('guid', 'guid'),
        FieldMapping('work_email', 'work_email'),
        FieldMapping('tz', 'environment.timezone'),
        FieldMapping('office_id', 'location.office.id', default=None),
        FieldMapping('created_at', 'created_at', datetime_from_str),
        FieldMapping('modified_at', '_meta.modified_at', datetime_from_str),
    ]

    @classmethod
    def create_local_model(cls, fields, exist_ok=True):
        login = fields['login']
        user_model = get_user_model()

        try:
            user_id = user_model.objects.get(username=login).id
        except user_model.DoesNotExist:
            # взято из механизма UpdateCenter, мб нужно единый механизм для создания пользователя
            user = user_model.objects.create(
                username=login,
                first_name=fields.get('first_name', login),
                last_name=fields.get('last_name', ''),
                email=fields.get('work_email', login + '@yandex-team.ru'),
            )
            user_id = user.id

        fields['user_id'] = user_id
        fields['login_ld'] = fields['login']

        super(StaffMapper, cls).create_local_model(fields, exist_ok)
