
from wiki.intranet.models.intranet_extensions import Service
from wiki.sync.staff.mapping.field_mapping import FieldMapping
from wiki.sync.staff.mapping.repository_mapper import RepositoryMapper
from wiki.sync.staff.utils import inject_dt


def join_array_with_colon(arr):
    return ', '.join(arr)


class ServiceMapper(RepositoryMapper):
    """
    Самая странная модель
    Дерево (MPTT)
    tree_id
    lft - экономия!
    rght
    level
    """

    repository_name = 'group'
    extra_lookups = {'type': 'service'}

    default_on_create = {'from_staff_id': 0}

    local_model = Service
    pk_mappings = [FieldMapping('id', 'service.id')]

    deps = {}

    field_filters_on_create = [inject_dt]

    field_mapping = [
        FieldMapping('parent_id', 'parent.service.id'),
        FieldMapping('name', 'name'),
        FieldMapping('url', 'url'),
    ]
