

class MapperRegistry(object):
    """
    Реестр мапперов. Нужен для того, что если у отображения есть зависимость, которую
    можно разрешить через другой маппер, можно было по локальной модели его найти
    и запросить синк этой модели
    """

    def __init__(self):
        self.reg = {}

    def register(self, mapper):
        """
        @param Type[RepositoryToModelMapper] mapper:
        @return:
        """

        self.reg[mapper.local_model.__name__] = mapper

    def get_mapper(self, klass):
        """
        @param Model klass:
        @return: RepositoryToModelMapper
        """

        return self.reg[klass.__name__]
