
from wiki.sync.staff.logger import sync_logger


class SyncNode:
    """
    Проекция объекта из источника данных в локальную модель, которая имеет какие-то зависимости, которые не
    были удовлетворены (напр. в локальной базе нет Department на который ссылается Staff)
    """

    mapper = None
    raw = None
    graph_built = False
    missing_dependencies = None

    def apply_dependency_graph(self):
        if not self.graph_built:
            raise ValueError('Please build graph first')

        for dep in self.missing_dependencies:
            dep.apply_dependency_graph()

        fields = self.mapper.convert_remote_to_model_fields(self.raw)

        try:
            self.mapper.create_local_model(fields)
        except Exception:
            sync_logger.exception('Fatal on creation %s, %s' % (self.mapper.local_model.__name__, fields))
            raise

        my_pk = {pk_mapper.field_name: fields[pk_mapper.field_name] for pk_mapper in self.mapper.pk_mappings}

        sync_logger.debug('%s %s created' % (self.mapper.local_model.__name__, my_pk))

    def __init__(self, mapper, raw):
        self.mapper = mapper
        self.raw = raw
        self.missing_dependencies = []
