
from wiki.sync.staff.mapping.models import (
    DepartmentMapper, GroupMapper, GroupMembershipMapper, OfficeMapper, StaffMapper, CountryMapper, CityMapper
)
from wiki.sync.staff.mapping.models.group import WikiGroupMapper, ServiceGroupMapper


def get_fullsync_projection():
    """
    Проекция для полной синхронизации это
    1). Источник данных (репозиторий сервиса staff с параметрами какие поля из него забирать и доп фильтрами)
    2). Маппер - отображение сырого словаря из источника данных на какую-то из локальных моделей.

    Некоторые модели маппятся на один и тот же репозиторий -
    просто нам надо из репозитория забрать чуть больше моделей -
    для этого функция make_datasource_for_mappers объединяет поля

    :rtype: Tuple[str, Datasource, List[RepositoryMapper]]
    """
    return [
        ('staff', StaffMapper.get_default_datasource(), [StaffMapper]),
        ('department', DepartmentMapper.get_joined_datasource(GroupMapper), [DepartmentMapper, GroupMapper]),
        ('wikigroup', WikiGroupMapper.get_default_datasource(), [WikiGroupMapper]),
        ('servicegroup', ServiceGroupMapper.get_default_datasource(), [ServiceGroupMapper]),
        ('groupmembership', GroupMembershipMapper.get_default_datasource(), [GroupMembershipMapper]),
        ('country', CountryMapper.get_default_datasource(), [CountryMapper]),
        ('city', CityMapper.get_default_datasource(), [CityMapper]),
        ('office', OfficeMapper.get_default_datasource(), [OfficeMapper]),
    ]
