from wiki.intranet.models.intranet_extensions import Group
from wiki.sync.staff.mapping.models import mapper_registry


def sync_single(klass, pk):
    mapper = mapper_registry.get_mapper(klass)
    ds = mapper.get_default_datasource()
    if len(mapper.pk_mappings) > 1:
        raise NotImplementedError()
    object = ds.get_object({mapper.pk_mappings[0].remote_field: pk})
    mapper.process_batch([object], mapper_registry)


def sync_group(pk):
    return sync_single(Group, pk)
