
from django.utils import timezone
from django.utils.dateparse import parse_datetime

boring_fields = {'modified_at', 'created_at'}


def update_model_fields(obj, fields, update_whole_model=False):
    changed_fields = []
    for key, new_value in fields.items():
        old_value = getattr(obj, key)
        if old_value != new_value:
            setattr(obj, key, new_value)
            changed_fields.append(key)

    not_boring_fields = set(changed_fields) - boring_fields

    # При апдейте может поменяться modified_at, но не поля которые мы трекаем в наших моделях
    # Не будем из-за этого обновлять поля.

    if not_boring_fields:
        if update_whole_model:
            obj.save()
        else:
            obj.save(update_fields=changed_fields)

        return True, not_boring_fields

    return False, not_boring_fields


def date_from_str(str_date):
    """Конвертирует str_date в datetime.date, если str_date != None, иначе возвращает None"""
    if str_date is None:
        return str_date
    return timezone.datetime.strptime(str_date, '%Y-%m-%d').date()


def inject_dt(fields):
    if not fields.get('modified_at'):
        fields['modified_at'] = timezone.now()

    if not fields.get('created_at'):
        fields['created_at'] = timezone.now()


def is_deleted_to_intranet_status(is_deleted):
    """
    Исторически в моделях есть поле intranet_status которое 1 если модель не удалена и 0 если удалена.
    Когда-нибудь мы переедим на нормальную логику, но пока что синкаемся с is_deleted
    @param bool is_deleted:
    @return:
    """
    return int(not is_deleted)


def datetime_from_str(str_date):
    if str_date is None:
        return str_date
    return parse_datetime(str_date)
