
from django.conf import settings

from wiki.sync.connect.models import SyncStatistics
from wiki.notifications.models import PageEvent, EventTypes
from wiki.pages.models import Page


def get_sync_stat():
    return SyncStatistics.objects.all()


def get_pages():
    return [
        Page.objects.filter(status=1).values_list('id').count(),
        Page.objects.filter(status=0).values_list('id').count(),
    ]


def get_edit_events():
    if settings.IS_BUSINESS:
        return PageEvent.objects.filter(event_type=EventTypes.edit, author__is_dir_robot=False)
    else:
        return PageEvent.objects.filter(event_type=EventTypes.edit)
