from celery.task import task

from wiki.unistat.cache import store_to_cache, store_oauth_token_ttl_data_to_cache
from wiki.unistat.logic import get_unistat_olap, get_oauth_token_ttl_data
from wiki.utils import lock


@task(ignore_result=True, name='wiki.update_unistat_cache')
@lock.get_lock_or_do_nothing('update_unistat_cache')
def update_unistat_cache():
    """
    Обновляет данные в MongoDB кэше, отдаваемые в unistat ручке.
    Это OLAP, то есть мы делаем постгрессу больно
    """
    store_to_cache(get_unistat_olap())


@task(ignore_result=True, name='wiki.update_unistat_cache_in_redis')
@lock.get_lock_or_do_nothing('update_unistat_cache_in_redis')
def update_unistat_cache_in_redis():
    """
    Обновляет данные в redis кэше, отдаваемые в unistat ручке.
    """
    store_oauth_token_ttl_data_to_cache(get_oauth_token_ttl_data())
