import django.views.static
from django.conf import settings
from django.conf.urls import include, url
from django.views.static import serve

from wiki.pages.views import favicon, tilde_redirect_to_user
from wiki.ping.views import ping_celery, ping_database, ping_sync_staff, ping_updatecenter, simple_ping
from wiki.unistat.views import UnistatView

handler403 = 'wiki.pages.views.page_not_allowed'
handler404 = 'wiki.pages.views.page_not_found'
handler500 = 'wiki.pages.views.server_error'


urlpatterns = []

if settings.DEBUG and getattr(settings, 'ROOT_PATH', ''):
    # это условие выполняется для разработческого инстанса
    # и не выполняется для установки из пакета.
    # Для установки из пакета смотри настройки конфига nginx.
    urlpatterns += [
        url(
            r'^_static/rest_framework/(?P<path>.*)$',
            django.views.static.serve,
            {
                'document_root': settings.ROOT_PATH
                + ('/.robe/dev/wiki/lib/python2.7/site-packages' '/rest_framework/static/rest_framework/')
            },
        ),
    ]

urlpatterns += [
    url(r'^_api/v1/', include(('wiki.api_v1.urls', 'wiki.api_v1'), namespace='api_v1')),
    # frontend API
    url(r'^_api/frontend/', include(('wiki.api_frontend.urls', 'wiki.api_frontend'), namespace='frontend')),
    # internal API (AD?)
    url(r'^_api/internal/', include(('wiki.api_internal.urls', 'wiki.api_internal'), namespace='internal')),
    # inter-service API
    url(r'^_api/svc/', include(('wiki.api_svc.urls', 'wiki.api_svc'), namespace='svc')),
    # intranet main page API
    url(r'^_api/imain/', include(('wiki.morda.urls', 'wiki.morda'), namespace='imain')),
    # ninja api --------------------
    url(r'^api/v2/', include(('wiki.api_v2.urls', 'wiki.api_v2'), namespace='apiv2')),
]

if settings.IS_BUSINESS:
    urlpatterns += [url(r'^_api/dir/', include(('wiki.sync.connect.urls', 'wiki.sync.connect'), namespace='connect'))]

if settings.IS_INTRANET:
    urlpatterns += [
        url(r'^idm/', include('django_idm_api.urls')),
    ]

urlpatterns += [
    url(r'^_api/', include('wiki.api.urls')),
    # resolving ~ aliases
    url(r'^\~(.*)$', tilde_redirect_to_user, name='tilde_user'),
    url(r'^ping$', simple_ping),
    url(r'^ping_database$', ping_database),
    url(r'^ping_celery$', ping_celery),
    url(r'^ping_sync_staff', ping_sync_staff),
    url(r'^ping_updatecenter', ping_updatecenter),
    url(r'^unistat$', UnistatView.as_view()),
    url(
        r'^_static_backend/(?P<path>.*)$',
        serve,
        name='static',
        kwargs=dict(document_root=settings.STATIC_ROOT),
    ),
    url(r'^favicon\.ico$', favicon),
]
