from django.contrib.admin import ModelAdmin
from django.contrib.auth.admin import UserAdmin as DjangoUserAdmin
from django.utils.translation import ugettext_lazy as _

from wiki.users.forms import AddUserForm, EditGroupForm, EditUserForm


class UserAdminExternal(DjangoUserAdmin):
    fieldsets = (
        (_('Personal info'), {'fields': ('first_name', 'last_name', 'email')}),
        (_('Permissions'), {'fields': ('is_active', 'is_staff', 'is_superuser', 'user_permissions')}),
        (_('Groups'), {'fields': ('groups',)}),
    )
    add_fieldsets = (
        (None, {'classes': ('wide',), 'fields': ('username', 'email', 'first_name', 'last_name', 'groups')}),
    )
    form = EditUserForm
    add_form = AddUserForm


class GroupAdminExternal(ModelAdmin):
    form = EditGroupForm


class UserAdminInternal(DjangoUserAdmin):
    search_fields = ('username', 'id', 'email', 'first_name', 'last_name')
