

from django.utils.translation import ugettext as _


def no_groups_with_ids(ids):
    """Удобный шорткат"""
    # Translators:
    #  ru: Нет групп со следующими id: "{0}"
    #  en: No groups with such ids: "{0}"
    return _('No groups with such ids: "{0}"').format(', '.join(map(str, ids)))


def groups_with_names_have_deleted_status(groups):
    # Translators:
    #  ru: Следующие группы имеют статус удаленные: "{0}"
    #  en: Groups with such names have the deleted status: "{0}"
    return _('Groups with such names have the deleted status: "{0}"').format(
        ', '.join(map(str, [group.name for group in groups]))
    )
