

from wiki.utils.logic import missing_primary_keys


def get_something_by_list_of_ids(getter, list_of_ids, id_attr_name):
    """
    Получить что-то по переданному списку из id с помощью функции getter.

    Вспомогательная функция.

    @type getter: callable
    @type list_of_ids: iterable
    @type id_attr_name: str
    @rtype: tuple
    @return: пару из (сущности, ids которым не соответствует сущность)
    """
    if not list_of_ids:
        return [], []
    models = getter(list_of_ids)
    return models, missing_primary_keys(models, list_of_ids, id_attr_name)
