

from cached_property import cached_property
from django.conf import settings as django_settings
from logging import getLogger

log = getLogger(__name__)


class RobotHandler(object):
    @cached_property
    def department_groups_that_are_never_robots(self):
        """
        @rtype: set
        @return: множество id департаментных групп из внутренних сервисов
        """
        from wiki.users.dao import departments_of_internal_services

        return {dep.id for dep in departments_of_internal_services()}

    def ignore_is_robot_flag(self, user):
        if not django_settings.IS_INTRANET:
            return False
        return user.staff.department_id in self.department_groups_that_are_never_robots

    def is_robot(self, user):
        return user.staff.is_robot and not self.ignore_is_robot_flag(user)


robot_handler = RobotHandler()


def is_robot(user):
    """
    Return True if user.staff value belongs to a robot user and False otherwise.

    @type user: Staff
    @rtype: bool
    """
    if not hasattr(user, 'staff'):
        log.warning('If you see that in production, this is a problem, this is only for tests')
        return False  # это только для тестов
    return robot_handler.is_robot(user)
