

from datetime import datetime
from django.conf import settings
from ids.registry import registry
from wiki.intranet.models import Staff
from django.contrib.auth import get_user_model
from wiki.personalisation.user_cluster import create_personal_page
from wiki.utils.tvm2 import get_service_ticket


def create_users_for_stand(*usernames):
    employees_repo = registry.get_repository(
        service='staff',
        resource_type='person',
        user_agent='wiki',
        service_ticket=get_service_ticket(settings.STAFFAPI_TVM2_CLIENT_ID),
    )
    for username in usernames:
        staff_response = employees_repo.get_one({'login': username})
        if not Staff.objects.filter(uid=staff_response['uid']).exists():
            staff = Staff(
                first_name=staff_response['name']['first']['ru'],
                last_name=staff_response['name']['last']['ru'],
                uid=staff_response['uid'],
                login=username,
                created_at=datetime.now(),
                modified_at=datetime.now(),
                login_ld=username,
                affiliation='yandex',
                work_email=staff_response['work_email'],
                gender='M' if staff_response['personal']['gender'] == 'male' else 'F',
                lang_ui=staff_response['language']['ui'],
            )
            staff.save()
            django_user = get_user_model().objects.create(
                username=username,
                email=staff_response['work_email'],
                is_staff=False,
                is_active=True,
                is_superuser=False,
            )
            staff.user = django_user
            staff.save()
        else:
            django_user = get_user_model().objects.get(username=username)

        django_user.is_staff = True
        django_user.is_superuser = True
        django_user.save()

        create_personal_page(django_user)
