
from django.core.management.base import BaseCommand
from wiki.intranet.models import Staff
from django.db import transaction
from django.contrib.auth import get_user_model


def user_ids_to_set_setting():
    """
    @rtype: int
    """
    return Staff.objects.exclude(lang_ui='ru').filter(is_dismissed=False).values_list('user_id', flat=True)


class Command(BaseCommand):
    help = 'Allow to translate content'
    requires_system_checks = False

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('-d', action='store_true', dest='dryrun', default=False, help='Do not save changes')

    def handle(self, *args, **options):
        for user_id in user_ids_to_set_setting():
            with transaction.atomic():
                user = get_user_model().objects.get(id=user_id)  # запрос внутри транзакции к auth_user
                if not options.get('dryrun'):
                    user.set_user_setting('propose_content_translation', True)
                print(('Set "propose_content_translation" to "{0}"'.format(user.username)))
