from django.conf import settings
from django.db import models
from enumfields import EnumField

from wiki.users.consts import UserFeatureCode, UserFeatureStatus


class UserFeature(models.Model):
    """
    Модель включения/отключения для пользователя нового или экспериментального функционала
    """

    id: int
    objects: models.Manager

    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE)

    feature_code = EnumField(UserFeatureCode, max_length=100)

    status = EnumField(UserFeatureStatus, max_length=50)

    enabled_at = models.DateTimeField(null=True)

    disabled_at = models.DateTimeField(null=True)

    def __str__(self):
        return f'id={self.id}, code={self.feature_code}, status={self.status}, user={self.user}'

    class Meta:
        constraints = [
            models.UniqueConstraint(fields=['user', 'feature_code'], name='user_feature_unique_user_feature_code')
        ]
