import logging

from wiki.users.consts import UserFeatureCode, UserFeatureStatus
from wiki.users.models import UserFeature
from wiki.utils.tasks.base import LockedCallableTask
from wiki.users.tasks.user_feature_handlers import data_ui_web
from wiki.utils.timezone import now

handlers = {
    UserFeatureCode.DATA_UI_WEB: data_ui_web.handle_feature,
}


class ProcessUserFeature(LockedCallableTask):
    name = 'wiki.process_user_feature'
    logger = logging.getLogger(name)
    time_limit = 900
    lock_name_tpl = 'process_user_feature_{feature_id}'

    def run(self, feature_id, *args, **kwargs):
        self.process_feature(feature_id)

    def process_feature(self, feature_id: int) -> None:
        feature = UserFeature.objects.get(id=feature_id)
        if feature.status in {UserFeatureStatus.ENABLED, UserFeatureStatus.DISABLED}:
            # Вероятнее всего запрос был уже обработан другой таской, нам тут делать нечего
            return

        if feature.status == UserFeatureStatus.PENDING_DISABLE:
            next_status = UserFeatureStatus.DISABLED
            feature.disabled_at = now()
        elif feature.status == UserFeatureStatus.PENDING_ENABLE:
            next_status = UserFeatureStatus.ENABLED
            feature.enabled_at = now()
        else:
            self.logger.error(f"can't find next status for {feature.status}")
            return

        if feature.feature_code in handlers:
            return handlers[feature.feature_code](feature, next_status)

        # Если нет никаких дополнительных обработчиков, просто обновляем статус
        feature.status = next_status
        feature.save()
